//=============================================================================
// C4.
//=============================================================================
class C4 extends ThrownProjectile;

var float	mpBlastRadius;
var float	mpLAMDamage;
var actor StuckTo; //what am i stuck to?
var vector StickOffset; //location difference between me and what im stuck to
var Rotator StickRotation; //at what angle am I stuck?

simulated function Tick(float DeltaTime)
{
 if (StuckTo != None)
 {
  SetRotation(StuckTo.Rotation + StickRotation);
  SetLocation(StuckTo.Location + (StickOffset >> StickRotation));
 }
}

simulated function Timer()
{
}

function ZoneChange(ZoneInfo NewZone)
{
 if (NewZone.bWaterZone)
 {
  SetPhysics(PHYS_Falling);
  Velocity.Z *= -1;
  Velocity.Z *= 0.75;
  StuckTo = None;
  StickOffset = vect(0,0,0);
  StickRotation = rot(0,0,0);
 }
}

simulated function PostBeginPlay()
{
 PlaySound(Sound'DeusExSounds.Weapons.LAMSelect');

 Super.PostBeginPlay();
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		Damage=mpLAMDamage;
		bIgnoresNanoDefense=True;
	}
}

auto simulated state Flying
{
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local ShockRing ring;
		local DeusExPlayer player;
		local float dist;

		// flash the screen white based on how far away the explosion is
		//		player = DeusExPlayer(GetPlayerPawn());
		//		MBCODE: Reference projectile owner to get player
		//		because sever fails to get it the old way
		player = DeusExPlayer(Owner);

		dist = Abs(VSize(player.Location - Location));

		// if you are at the same location, blind the player
		if (dist ~= 0)
			dist = 10.0;
		else
			dist = 2.0 * FClamp(blastRadius/dist, 0.0, 4.0);

		if (damageType == 'EMP')
			player.ClientFlash(dist, vect(0,200,1000));
		else if (damageType == 'TearGas')
			player.ClientFlash(dist, vect(0,1000,100));
		else
			player.ClientFlash(dist, vect(1000,1000,900));

      //DEUS_EX AMSD Only do visual effects if client or if destroyed via damage (since the client can't detect that)
      if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority) || bDamaged)
      {
         SpawnEffects(HitLocation, HitNormal, None);
         DrawExplosionEffects(HitLocation, HitNormal);
      }

		if ((damageType=='TearGas') && (Role==ROLE_Authority))
			SpawnTearGas();

		PlayImpactSound();

		if ( AISoundLevel > 0.0 )
			AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, AISoundLevel*blastRadius*16);

		GotoState('Exploding');
	}
	simulated function HitWall (vector HitNormal, actor HitWall)
	{
         SetPhysics(PHYS_None);
         StuckTo = HitWall;
         StickOffset = Location - Hitwall.Location;
         StickRotation = Rotation;
         SetCollision(False,False,True);
//	 SetBase(HitWall);
	}
	simulated function ProcessTouch(actor Other, vector HitLocation)
	{
         SetCollision(False,False,True);
         SetPhysics(PHYS_None);
         StuckTo = Other;
         StickOffset = Location - Other.Location;
         StickRotation = Rotation;
         SetCollision(False,False,True);
//	 SetBase(Other);
	}
}

defaultproperties
{
     mpBlastRadius=288.000000
     mpLAMDamage=250.000000
     blastRadius=288.000000
     spawnWeaponClass=Class'MSC4.WeaponC4'
     ItemName="C4 Plastic Explosive"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=250.000000
     MomentumTransfer=50000
     ImpactSound=Sound'DeusExSounds.Weapons.LAMExplode'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     Skin=Texture'DeusExItems.Skins.LAM3rdTex1'
     Mesh=LodMesh'DeusExItems.LAMPickup'
     CollisionRadius=4.300000
     CollisionHeight=3.800000
     Mass=2.500000
     Buoyancy=2.000000
     DrawScale=1.230000
     elasticity=0.500000
     fuseLength=0.000000
     FragmentClass=Class'DeusEx.Rockchip'
     bFirstHit=True
     bHighlight=True
     AISoundLevel=1.000000
     bExplodes=True
     bBlood=True
     bDebris=True
     DamageType=exploded
     ItemArticle="a"
     MiscSound=Sound'DeusExSounds.Generic.MetalBounce1'
     Physics=PHYS_Falling
     bBounce=True
     bFixedRotationDir=True
}
